package com.ejie.ab04b.service;

import java.util.HashMap;
import java.util.List;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.foldermanagement.xml.DocumentEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0465s00Service generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

public interface DocumentoAperturasService {

	/**
	 * Inserts a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	DocumentoAperturas add(DocumentoAperturas ab0465s00);

	/**
	 * Inserts a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  temp
	 *            boolean
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param temp the temp
	 * @return the documento aperturas
	 */
	DocumentoAperturas add(DocumentoAperturas ab0465s00, boolean temp);

	/**
	 * Inserts a single row in the Ab0465s00 table.
	 * 
	 *  documents
	 *            List<DocumentEvent>
	 *  fechaCreacion
	 *            String
	 *  idTramite
	 *            Long
	 *
	 * @param documents the documents
	 * @param fechaCreacion the fecha creacion
	 * @param idTramite the id tramite
	 */
	public void addDocumentosSolicitud(List<DocumentEvent> documents,
			String fechaCreacion, Long idTramite);

	/**
	 * Updates a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	DocumentoAperturas update(DocumentoAperturas ab0465s00);

	/**
	 * Updates a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	public DocumentoAperturas updateFilled(DocumentoAperturas ab0465s00);

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	DocumentoAperturas find(DocumentoAperturas ab0465s00);

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	DocumentoAperturas findTemp(DocumentoAperturas ab0465s00);

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  oid
	 *            String
	 *  DocumentoAperturas
	 *
	 * @param oid the oid
	 * @return the documento aperturas
	 */
	public DocumentoAperturas findByOid(String oid);

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	DocumentoAperturas findByTramite(DocumentoAperturas ab0465s00);

	/**
	 * Deletes a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 */
	void remove(DocumentoAperturas ab0465s00);

	/**
	 * Deletes a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 */
	void removeTemp(DocumentoAperturas ab0465s00);

	/**
	 * Removes a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 */
	void removeTempByIdApertura(DocumentoAperturas ab0465stemp);

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<DocumentoAperturas> findAll(DocumentoAperturas ab0465s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0465s00 table using like.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<DocumentoAperturas> findAllLike(DocumentoAperturas ab0465s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión).
	 * 
	 *  documento
	 *            SolicDocAperturas
	 *  List<SolicDocAperturas>
	 *
	 * @param documento the documento
	 * @return the list
	 */
	public List<DocumentoAperturas> buscarDocumentosAperturasTempIdApe(
			DocumentoAperturas documento);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0465s00 table.
	 * 
	 *  filterAb0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0465s00>
	 *
	 * @param filterAb0465s00 the filter ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<DocumentoAperturas> filter(
			DocumentoAperturas filterAb0465s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0465s00 table.
	 * 
	 *  filterAb0465s00
	 *            Ab0465s00
	 *  searchAb0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0465s00>>
	 *
	 * @param filterAb0465s00 the filter ab 0465 s 00
	 * @param searchAb0465s00 the search ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<DocumentoAperturas>> search(
			DocumentoAperturas filterAb0465s00,
			DocumentoAperturas searchAb0465s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0465s00 table.
	 * 
	 *  filterAb0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0465s00 the filter ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(DocumentoAperturas filterAb0465s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the list
	 */
	List<DocumentoAperturas> findAllAperturaTipo(DocumentoAperturas ab0465s00);

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 * 
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the list
	 */
	List<DocumentoAperturas> findAllAperturaTipoTemp(
			DocumentoAperturas ab0465s00);

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 * 
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the list
	 */
	List<DocumentoAperturas> findAllAperturaInspeccion(
			DocumentoAperturas ab0465s00);

	/**
	 * Sube fichero PIF.
	 * 
	 *  datosFichero
	 *            byte[]
	 *  rutaFichero
	 *            String
	 *  nombreFichero
	 *            String
	 *  preservaName
	 *            boolean
	 *  DocumentoAperturas
	 *
	 * @param datosFichero the datos fichero
	 * @param rutaFichero the ruta fichero
	 * @param nombreFichero the nombre fichero
	 * @param preservaName the preserva name
	 * @return the documento aperturas
	 * @throws AB04BException the AB 04 B exception
	 */
	public DocumentoAperturas subeFicheroPIF(byte[] datosFichero,
			String rutaFichero, String nombreFichero, boolean preservaName)
			throws AB04BException;

	/**
	 * Borrar documento.
	 * 
	 *  codDocumento
	 *            Long
	 *  temp
	 *            boolean
	 *  HashMap<String, String>
	 *
	 * @param codDocumento the cod documento
	 * @param temp the temp
	 * @return the hash map
	 * @throws AB04BException the AB 04 B exception
	 */
	HashMap<String, String> borrarDocumento(Long codDocumento, boolean temp)
			throws AB04BException;

	/**
	 * Descargar documento.
	 * 
	 *  rutaCompletaFichero
	 *            String
	 *  byte[]
	 *
	 * @param rutaCompletaFichero the ruta completa fichero
	 * @return the byte[]
	 * @throws AB04BException the AB 04 B exception
	 */
	byte[] descargarDocumento(String rutaCompletaFichero) throws AB04BException;

	/**
	 * Adds the documentos temp.
	 * 
	 *  documentEvent
	 *            the document event
	 *  registryTimestamp
	 *            the registry timestamp
	 *  idTramite
	 *            the id tramite
	 *
	 * @param documentEvent the document event
	 * @param registryTimestamp the registry timestamp
	 * @param idTramite the id tramite
	 */
	void addDocumentosTemp(List<DocumentEvent> documentEvent,
			String registryTimestamp, Long idTramite);

}
